let $$ = require('cdev/ncore')({ debug: true });
let csv = require('common/csv');

const csvOptions = { header: true, delimiter: ';', encoding: 'utf-8' };
let csvFolder = $$.objects.tryFind('/agorum/roi/workspace/isg.xpert.archive/csv');

csvFolder.items().forEach(csvFile => {
  let result = ['#', '# terms translation keys for [{0}]'.format(csvFile.baseName), '#'];
  $$.debug(csvFile.baseName);
  (csv.read(csvFile, csvOptions) || []).forEach(row => {
    result.push('isg.xpert.archive.terms.translate.{0}.{1}={2}'.format(csvFile.baseName, row.value, row.text));
  });
  result.push('');
  $$.debug(result.join('\n'));
});
